package ru.yandex.solomon.alert.util;

import java.util.concurrent.TimeUnit;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.DefaultThreadFactory;

/**
 * @author Vladimir Gordiychuk
 */
public class Async {
    private static final Timer DEFAULT_TIMER = new HashedWheelTimer(new DefaultThreadFactory("Timer", true));

    private Async() {
    }

    public static Timeout runAfter(TimerTask task, long delay, TimeUnit unit) {
        return DEFAULT_TIMER.newTimeout(task, delay, unit);
    }

}
