package ru.yandex.solomon.alert.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.math.doubles.AggregateFunctionType;
import ru.yandex.solomon.math.protobuf.Aggregation;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class Converters {
    private Converters() {
    }

    @Nonnull
    public static Aggregation aggregateFunctionToProto(@Nullable AggregateFunctionType fn) {
        if (fn == null) {
            return Aggregation.DEFAULT_AGGREGATION;
        }

        switch (fn) {
            case SUM:
                return Aggregation.SUM;
            case AVG:
                return Aggregation.AVG;
            case MIN:
                return Aggregation.MIN;
            case MAX:
                return Aggregation.MAX;
            case LAST:
                return Aggregation.LAST;
            case COUNT:
                return Aggregation.COUNT;
            case DEFAULT:
                return Aggregation.DEFAULT_AGGREGATION;
            default:
                return Aggregation.UNRECOGNIZED;
        }
    }
}
