package ru.yandex.solomon.alert.util;

import java.util.Spliterator;
import java.util.function.DoubleConsumer;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;

/**
 * @author Vladimir Gordiychuk
 */
public class DoublePointSpliterator implements Spliterator.OfDouble {
    private final int characteristics;
    private long estimatedSize;
    private AggrGraphDataListIterator iterator;
    private AggrPoint tempPoint;

    public DoublePointSpliterator(long estimatedSize, AggrGraphDataListIterator iterator) {
        this.estimatedSize = estimatedSize;
        this.iterator = iterator;
        this.tempPoint = new AggrPoint();
        this.characteristics = Spliterator.IMMUTABLE | Spliterator.NONNULL | Spliterator.SIZED;
    }

    public DoublePointSpliterator(AggrGraphDataListIterator iterator) {
        this.estimatedSize = Long.MAX_VALUE;
        this.iterator = iterator;
        this.tempPoint = new AggrPoint();
        this.characteristics = Spliterator.IMMUTABLE | Spliterator.NONNULL;
    }

    @Override
    public OfDouble trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return estimatedSize;
    }

    @Override
    public int characteristics() {
        return characteristics;
    }

    @Override
    public boolean tryAdvance(DoubleConsumer action) {
        boolean hasNext = iterator.next(tempPoint);
        if (!hasNext) {
            return false;
        }

        action.accept(tempPoint.getValueDivided());
        return true;
    }

    @Override
    public void forEachRemaining(DoubleConsumer action) {
        while (iterator.next(tempPoint)) {
            action.accept(tempPoint.getValueDivided());
        }
    }
}
