package ru.yandex.solomon.alert.util;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.concurrent.CompletableFutures;
import ru.yandex.solomon.expression.exceptions.SelException;
import ru.yandex.solomon.metrics.client.MetabaseClientException;
import ru.yandex.solomon.metrics.client.StockpileClientException;
import ru.yandex.solomon.metrics.client.exceptions.DataClientException;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class ExceptionResolver {

    public static RuntimeException resolve(Throwable throwable) {
        Throwable cause = CompletableFutures.unwrapCompletionException(throwable);

        if (cause instanceof SelException selException) {
            return selException;
        }
        if (cause instanceof MetabaseClientException metabaseClientException) {
            return metabaseClientException;
        }
        if (cause instanceof StockpileClientException stockpileClientException) {
            return stockpileClientException;
        }
        if (cause instanceof DataClientException dataClientException) {
            return dataClientException;
        }
        return new ResovledByUUIDRuntimeException(cause);
    }

}
