package ru.yandex.solomon.alert.util;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.selfmon.failsafe.RateLimiter;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
class RateLimitImpl implements RateLimit {
    private final RateLimiter limiter;

    RateLimitImpl(RateLimiter limiter) {
        this.limiter = limiter;
    }

    @Override
    public boolean attempt() {
        return limiter.acquire();
    }
}
