package ru.yandex.solomon.alert.util;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class RateLimitedRunner {
    private final AtomicLong nextRunTimeMillis = new AtomicLong(0);
    private final long nextRunDelayMillis;
    private final LongConsumer runnable;

    public RateLimitedRunner(Duration nextRunDelay, LongConsumer runnable) {
        nextRunDelayMillis = nextRunDelay.toMillis();
        this.runnable = runnable;
    }

    public boolean runIfNecessary(long nowMillis) {
        long nextRunTimeMillisOld = nextRunTimeMillis.get();
        if (nowMillis > nextRunTimeMillisOld) {
            if (nextRunTimeMillis.compareAndSet(nextRunTimeMillisOld, nowMillis + nextRunDelayMillis)) {
                runnable.accept(nowMillis);
                return true;
            }
        }
        return false;
    }
}
