package ru.yandex.solomon.alert.util;

import java.time.Clock;
import java.time.Duration;

import ru.yandex.solomon.selfmon.failsafe.TokenBucketRateLimiter;

/**
 * @author Vladimir Gordiychuk
 */
public class RateLimiters {
    public static RateLimit create(int maxPermitsPerSeconds) {
        return create(maxPermitsPerSeconds, Duration.ofSeconds(1));
    }

    public static RateLimit create(int maxPermitsPerInterval, Duration interval) {
        return new RateLimitImpl(new TokenBucketRateLimiter(Clock.systemUTC(), maxPermitsPerInterval, interval));
    }

    public static RateLimit noop() {
        return NoopRateLimit.INSTANCE;
    }
}
