package ru.yandex.solomon.alert.util;

import java.util.UUID;

/**
 * @author Ivan Tsybulin
 */
public class ResovledByUUIDRuntimeException extends RuntimeException {
    private final UUID uuid;

    public ResovledByUUIDRuntimeException(Throwable cause) {
        this(cause, UUID.randomUUID());
    }

    public ResovledByUUIDRuntimeException(Throwable cause, UUID uuid) {
        super("[" + uuid + "] " + cause.getClass().getCanonicalName() + ": " + cause.getMessage(), cause);
        this.uuid = uuid;
        setStackTrace(new StackTraceElement[0]);
    }

    public UUID getUuid() {
        return uuid;
    }
}
