package ru.yandex.solomon.alert.yachats;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * @author Nikita Minin
 */
public interface YaChatsClient extends AutoCloseable {

    CompletableFuture<Response> sendMessage(String login, String groupId, String text);

    CompletableFuture<List<GroupsInfo>> getChats();

    final class Response {
        private final int statusCode;
        private final String message;

        public Response(int statusCode, String message) {
            this.statusCode = statusCode;
            this.message = message;
        }

        public int getStatusCode() {
            return statusCode;
        }

        public String getMessage() {
            return message;
        }
    }

    final class GroupsInfo {
        private final String id;
        private final String title;
        private final String description;

        public GroupsInfo(String id, String title, String description) {
            this.id = id;
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return title;
        }

        public String getId() {
            return id;
        }

        public String getDescription() {
            return description;
        }
    }

}
