JAVA_PROGRAM(alerting)

OWNER(g:solomon)

INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/jdk.inc)

JAVA_SRCS(
    PACKAGE_PREFIX ru.yandex.solomon.alert
    SRCDIR src
    **/*.java
    **/*.mustache
    **/*.sql
    **/*.yql
)

INCLUDE(${ARCADIA_ROOT}/solomon/libs/java/contribs.inc)

PEERDIR(
    # spring
    contrib/java/org/springframework/spring-core
    contrib/java/org/springframework/spring-context

    solomon/libs/java/alerting-client
    solomon/libs/java/auth
    solomon/libs/java/conf-db # TODO: remove this huge dependency
    solomon/libs/java/config
    solomon/libs/java/distributed-lock
    solomon/libs/java/distributed-scheduler
    solomon/libs/java/idempotency
    solomon/libs/java/expression
    solomon/libs/java/labels
    solomon/libs/java/main
    solomon/libs/java/metrics-client
    solomon/libs/java/name-resolver-client
    solomon/libs/java/quotas-watcher
    solomon/libs/java/service-ctx
    solomon/libs/java/ts-codec
    solomon/libs/java/yandex/abc-context
    solomon/libs/java/yandex/ambry
    solomon/libs/java/yandex/blackbox
    solomon/libs/java/yandex/cloud-auth
    solomon/libs/java/yandex/jns
    solomon/libs/java/yandex/juggler
    solomon/libs/java/yandex/staff
    solomon/libs/java/yandex/yasms
    solomon/libs/java/yasm-alert-converter
    solomon/libs/java/cluster-discovery
    solomon/libs/java/balancer
    solomon/libs/java/tracing
    solomon/libs/java/grpc-conf
    solomon/protos/alerting

    iceberg/commune-mail
    iceberg/commune-json
    iceberg/misc
    yt/java/ytclient

    solomon/libs/java/kikimr-kv-client

    # 3rd-party dependency
    contrib/java/io/netty/netty-all
    contrib/java/com/github/spullara/mustache/java/compiler/0.9.5
    contrib/java/org/asynchttpclient/async-http-client

    contrib/java/com/fasterxml/jackson/core/jackson-core
    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/core/jackson-annotations
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-xml
    contrib/java/javax/annotation/javax.annotation-api
)

EXCLUDE(
    ${service_excludes}
    contrib/java/org/springframework/spring-tx
    contrib/java/org/openjdk/jmh/jmh-generator-annprocess
    contrib/java/com/fasterxml/jackson/core/jackson-core/2.6.4

    solomon/libs/java/fetcher-client
    solomon/libs/java/coremon-client
)

CHECK_JAVA_DEPS(yes)

LINT(base)
END()

RECURSE_FOR_TESTS(
    conftest
    ut
)
