#!/bin/sh -e

ya --version > /dev/null 2> /dev/null || ( \
    echo "ya is not found in PATH, please adjust PATH, e.g. PATH=\$PATH:/home/user/arcadia ./recanonize.sh" \
    && exit 1 )

ya make -DJDK_VERSION=15
./run.sh --enable-preview \
    -Dru.yandex.solomon.LabelValidator=skip \
    ru.yandex.solomon.alert.canon.RegenerateCanonResults

read -p "Have you read the log above and ready to commit the new results as canonical? (y/N) " REPLY
echo
case "$REPLY" in
    y|Y ) ;;
    n|N ) exit 1;;
    *) exit 1;;
esac 

echo "Uploading to sandbox, this might take a while"
RID=$(ya upload --ttl inf /tmp/alert_canon_data.jar --json-output | jq .resource_id)
echo "Uploaded as $RID"
sed -i "s/JAR_RESOURCE([0-9]\+)/JAR_RESOURCE(${RID})/" ../canon-data/ya.make

echo "Please commit changes in ../canon-data/ya.make"
