package ru.yandex.solomon.alert.canon;

import org.junit.Assert;

/**
 * @author Ivan Tsybulin
 */
public record Check(Method method, String explanation) {
    public static final Check FULL_CHECK = new Check(Method.FULL_CHECK, "");

    public static Check ignore(String explanation) {
        Assert.assertFalse("Test cannot be ignored without an explanation", explanation.isEmpty());
        return new Check(Method.IGNORED, explanation);
    }

    public enum Method {
        FULL_CHECK,
        IGNORED,
    }
}
