package ru.yandex.solomon.alert.canon;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Assert;

import ru.yandex.monlib.metrics.labels.validate.InvalidLabelException;
import ru.yandex.monlib.metrics.labels.validate.LabelsValidator;
import ru.yandex.solomon.alert.domain.AlertKey;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class IgnoredTests {
    public final static Map<AlertKey, Check> IGNORED_KEYS;

    static {

        try {
            LabelsValidator.checkKeyValid("foo-bar");
        } catch (InvalidLabelException e) {
            Assert.fail("Run with -Dru.yandex.solomon.LabelValidator=skip");
        }

        IGNORED_KEYS = new HashMap<>();
        IGNORED_KEYS.put(new AlertKey("yasm_yasmambry", "", "4c7149d9-3755-39be-be09-b6b2deb8524f"),
                Check.ignore("Changed HistogramPointCollector for histogram to UgramPointValueCollector"));
    }
}
