package ru.yandex.solomon.alert.canon.protobuf;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.salmon.proto.StockpileCanonicalProto;
import ru.yandex.solomon.codec.archive.MetricArchiveGeneric;
import ru.yandex.solomon.metrics.client.ArchiveConverter;
import ru.yandex.stockpile.ser.test.convert.ArchiveConverters;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class ArchiveConverterImpl implements ArchiveConverter {
    public static final ArchiveConverterImpl I = new ArchiveConverterImpl();

    private ArchiveConverterImpl() {
    }

    @Override
    public StockpileCanonicalProto.Archive toProto(MetricArchiveGeneric archive) {
        return ArchiveConverters.toProto(archive);
    }

    @Override
    public MetricArchiveGeneric fromProto(StockpileCanonicalProto.Archive proto) {
        return ArchiveConverters.fromProto(proto);
    }
}
