package ru.yandex.solomon.alert.canon.protobuf;

import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.salmon.proto.StockpileCanonicalProto;
import ru.yandex.solomon.alert.api.converters.AlertConverter;
import ru.yandex.solomon.alert.rule.AlertTimeSeries;
import ru.yandex.solomon.alert.rule.ExplainResult;
import ru.yandex.solomon.alerting.canon.protobuf.TAlertTimeSeries;
import ru.yandex.solomon.alerting.canon.protobuf.TExplainResult;
import ru.yandex.solomon.codec.archive.MetricArchiveGeneric;
import ru.yandex.solomon.codec.archive.MetricArchiveImmutable;
import ru.yandex.solomon.labels.protobuf.LabelConverter;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.stockpile.ser.test.convert.ArchiveConverters;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Converter {
    private static StockpileCanonicalProto.Archive toProto(AggrGraphDataIterable source) {
        if (source instanceof MetricArchiveGeneric) {
            return ArchiveConverters.toProto((MetricArchiveGeneric) source);
        }
        return toProto(MetricArchiveImmutable.of(source));
    }

    public static TExplainResult toProto(ExplainResult result) {
        return TExplainResult.newBuilder()
                .setEvaluationStatus(AlertConverter.statusToProto(result.getStatus()))
                .addAllSeries(result.getSeries().stream().map(Converter::toProto).collect(Collectors.toList()))
                .build();
    }

    private static TAlertTimeSeries toProto(AlertTimeSeries timeSeries) {
        return TAlertTimeSeries.newBuilder()
                .setAlias(timeSeries.getAlias())
                .setLabels(LabelConverter.labelsToProto(timeSeries.getLabels()))
                .setSource(ArchiveConverters.toProto(MetricArchiveImmutable.of(timeSeries.getSource())))
                .build();
    }
}
