#!/bin/sh

set -e
set -x

if [ ! -f "${APPLICATION_CONFIG}" ]; then
    cat etalon_application.conf | envsubst > "${APPLICATION_CONFIG}"
fi

exec java \
    -server -showversion \
    -classpath "${PWD}/lib/*" \
    -Djava.security.egd=file:/dev/./urandom \
    -Djava.net.preferIPv6Addresses=true \
    -XX:+UnlockCommercialFeatures \
    -XX:+FlightRecorder \
    -XX:+UnlockDiagnosticVMOptions \
    -XX:+DebugNonSafepoints \
    -XX:+UseParallelGC \
    -XX:+UseGCOverheadLimit -XX:GCTimeLimit=95 -XX:GCHeapFreeLimit=2 \
    -Xms1g -Xmx3g \
    -Dru.yandex.solomon.LabelValidator=skip \
    ru.yandex.solomon.alert.AlertingMain --config="${APPLICATION_CONFIG}"
