package ru.yandex.solomon.coremon;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.config.protobuf.coremon.TCoremonConfig;
import ru.yandex.solomon.main.SpringContexts;

import static ru.yandex.solomon.config.SolomonConfigs.parseConfigWithoutInclude;

/**
 * @author Sergey Polovko
 */
@RunWith(Parameterized.class)
public class CoremonMainContextTest {

    @Rule
    public Timeout timeout = Timeout.builder()
            .withLookingForStuckThread(true)
            .withTimeout(1, TimeUnit.MINUTES)
            .build();

    @Parameterized.Parameter
    public String configFile;

    @Parameterized.Parameters(name = "{0}")
    public static String[] configs() {
        return new String[]{
                "dev/coremon.dev.conf",
                "testing/coremon.conf",
                "prestable/coremon.conf",
                "production/coremon.sas.conf",
                "production/coremon.vla.conf",
                "cloud-preprod/coremon.conf",
                "cloud-prod/coremon.vla.conf",
                "cloud-prod/coremon.sas.conf",
        };
    }

    @Test
    public void testConfiguration() {
        if (!Files.exists(Path.of(configFile))) {
            Assert.fail("cannot find file " + configFile + ", CWD: " + Path.of(".").toAbsolutePath().normalize());
        }

        var config = parseConfigWithoutInclude(configFile, TCoremonConfig.getDefaultInstance());
        Assert.assertNotEquals(TCoremonConfig.getDefaultInstance(), config);

        try (var ctx = SpringContexts.createSimple(CoremonMainContext.class, config)) {
            Assert.assertEquals(config, ctx.getBean(TCoremonConfig.class));
        }
    }
}
