package ru.yandex.solomon.coremon;

import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.cloud.resource.resolver.FolderResolver;
import ru.yandex.solomon.config.protobuf.coremon.TCoremonCreateShardConfig;
import ru.yandex.solomon.config.protobuf.coremon.TCoremonMetabaseConfig;
import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.core.conf.ShardNumIdGenerator;
import ru.yandex.solomon.core.conf.ShardNumIdGeneratorImpl;
import ru.yandex.solomon.core.conf.flags.FeatureFlagsContext;
import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;
import ru.yandex.solomon.core.conf.watch.SolomonConfWatcher;
import ru.yandex.solomon.core.db.dao.ClustersDao;
import ru.yandex.solomon.core.db.dao.ProjectsDao;
import ru.yandex.solomon.core.db.dao.ServicesDao;
import ru.yandex.solomon.core.db.dao.ShardsDao;
import ru.yandex.solomon.coremon.api.CoremonGrpcContext;
import ru.yandex.solomon.coremon.balancer.ShardBalancerContext;
import ru.yandex.solomon.coremon.client.CoremonClient;
import ru.yandex.solomon.coremon.client.CoremonClientStub;
import ru.yandex.solomon.coremon.db.YdbClientsContext;
import ru.yandex.solomon.coremon.meta.service.MetabaseGrpcServerContext;
import ru.yandex.solomon.coremon.meta.ttl.DeletionManager;
import ru.yandex.solomon.coremon.meta.ttl.UnknownReferenceTrackerContext;
import ru.yandex.solomon.coremon.meta.ttl.UnknownReferenceWww;
import ru.yandex.solomon.coremon.shards.ShardCreator;
import ru.yandex.solomon.coremon.www.CoremonLocalShardsWww;
import ru.yandex.solomon.ctx.ServiceAuthContext;
import ru.yandex.solomon.http.filters.RequestLoggingFilter;
import ru.yandex.solomon.selfmon.GeneralMonitoringContext;
import ru.yandex.solomon.selfmon.mon.SelfMetricsController;
import ru.yandex.solomon.staffOnly.StaffOnlyController;
import ru.yandex.solomon.staffOnly.StaffOnlyRedirectController;
import ru.yandex.solomon.staffOnly.manager.ManagerController;
import ru.yandex.solomon.tracing.TracingContext;
import ru.yandex.solomon.util.net.NetworkValidator;
import ru.yandex.solomon.util.net.StubNetworkValidator;
import ru.yandex.stockpile.client.GrpcStockpileClientConfigContext;

/**
 * @author Stepan Koltsov
 */
@Import({
    CoremonStateContext.class,
    RequestLoggingFilter.class,
    StaffOnlyController.class,
    StaffOnlyRedirectController.class,
    SelfMetricsController.class,
    ManagerController.class,
    DeletionManager.class,
    GrpcStockpileClientConfigContext.class,
    MetabaseGrpcServerContext.class,
    CoremonGrpcContext.class,
    GeneralMonitoringContext.class,
    LazyThreadPoolProvider.class,
    SolomonConfWatcher.class,
    SolomonConfHolder.class,
    YdbClientsContext.class,
    ShardBalancerContext.class,
    ServiceAuthContext.class,
    FeatureFlagsContext.class,
    CoremonCloudContext.class,
    TracingContext.class,
    CoremonLocalShardsWww.class,
    UnknownReferenceWww.class,
    UnknownReferenceTrackerContext.class,
    CoremonSchedulerContext.class,
    ProjectManagerClientContext.class,
})
@Configuration
public class CoremonMainContext {

    @Bean
    public Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    public NetworkValidator networkValidator() {
        return new StubNetworkValidator();
    }

    @Bean
    public CoremonClient coremonClient() {
        return new CoremonClientStub();
    }

    @Bean
    TCoremonMetabaseConfig.TTtlDeletionConfig metabaseTtlDeletionConfig(TCoremonMetabaseConfig config) {
        return config.getTtlDeletionConfig();
    }

    @Bean
    public ShardNumIdGeneratorImpl shardNumIdGenerator(ShardsDao shardsDao, ThreadPoolProvider threads, MetricRegistry registry) {
        var executor = threads.getExecutorService("CpuLowPriority", "ThreadPools");
        var timer = threads.getSchedulerExecutorService();
        return new ShardNumIdGeneratorImpl(shardsDao, executor, timer, registry);
    }

    @Bean
    ShardCreator shardCreator(
            ProjectsDao projectsDao,
            ShardsDao shardsDao,
            ClustersDao clustersDao,
            ServicesDao servicesDao,
            ShardNumIdGenerator shardNumIdGenerator,
            TCoremonCreateShardConfig createShardConfig,
            ThreadPoolProvider threads,
            MetricRegistry metricRegistry,
            Optional<FolderResolver> folderResolver)
    {
        ExecutorService executor = threads.getExecutorService(
                createShardConfig.getThreadPoolName(),
                "CreateShardConfig.ThreadPoolName");
        return new ShardCreator(
            projectsDao,
            shardsDao,
            clustersDao,
            servicesDao,
            shardNumIdGenerator,
            createShardConfig,
            executor,
            metricRegistry,
            folderResolver);
    }
}
