package ru.yandex.solomon.coremon;

import javax.annotation.concurrent.Immutable;

import ru.yandex.solomon.core.db.model.Shard;

/**
 * @author Sergey Polovko
 */
@Immutable
public class CoremonShardQuota {

    public static final CoremonShardQuota DEFAULT = new CoremonShardQuota(0, 0, 0);

    private final int maxMetricsPerUrl;
    private final int maxFileMetrics;
    private final int maxMemMetrics;

    public CoremonShardQuota(int maxMetricsPerUrl, int maxFileMetrics, int maxMemMetrics) {
        this.maxMetricsPerUrl = Math.max(maxMetricsPerUrl, Shard.DEFAULT_PER_URL_QUOTA);
        this.maxFileMetrics = Math.max(maxFileMetrics, Shard.DEFAULT_FILE_METRIC_QUOTA);
        this.maxMemMetrics = Math.max(maxMemMetrics, Shard.DEFAULT_MEM_METRIC_QUOTA);
    }

    public int getMaxMetricsPerUrl() {
        return maxMetricsPerUrl;
    }

    public int getMaxFileMetrics() {
        return maxFileMetrics;
    }

    public int getMaxMemMetrics() {
        return maxMemMetrics;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CoremonShardQuota that = (CoremonShardQuota) o;

        if (maxMetricsPerUrl != that.maxMetricsPerUrl) return false;
        if (maxFileMetrics != that.maxFileMetrics) return false;
        return maxMemMetrics == that.maxMemMetrics;
    }

    @Override
    public int hashCode() {
        int result = maxMetricsPerUrl;
        result = 31 * result + maxFileMetrics;
        result = 31 * result + maxMemMetrics;
        return result;
    }

    @Override
    public String toString() {
        return "CoremonShardQuotas{" +
            "maxMetricsPerUrl=" + maxMetricsPerUrl +
            ", maxFileMetrics=" + maxFileMetrics +
            ", maxMemMetrics=" + maxMemMetrics +
            '}';
    }
}
