package ru.yandex.solomon.coremon;

import java.util.Optional;
import java.util.concurrent.ExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.coremon.TCoremonEngineConfig;
import ru.yandex.solomon.config.protobuf.coremon.TMetabaseMetricNameMigrationConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.core.conf.SolomonConfManager;
import ru.yandex.solomon.coremon.meta.db.MetricsDaoFactory;
import ru.yandex.solomon.coremon.meta.db.ydb.YdbDeletedMetricsDaoContext;
import ru.yandex.solomon.coremon.meta.db.ydb.YdbMetricsDaoContext;
import ru.yandex.solomon.coremon.stockpile.MetricProcessorFactory;
import ru.yandex.solomon.coremon.stockpile.ProcessingWriter;
import ru.yandex.solomon.coremon.stockpile.ServiceProviderMetricsSupplier;
import ru.yandex.solomon.coremon.stockpile.write.StockpileBufferedWriter;
import ru.yandex.solomon.ctx.ServiceAuthContext;
import ru.yandex.stockpile.client.StockpileClient;


/**
 * @author Stepan Koltsov
 */
@Configuration
@Import({
    CoremonState.class,
    CoremonStateMetrics.class,
    SolomonConfManager.class,
    YdbMetricsDaoContext.class,
    YdbDeletedMetricsDaoContext.class,
    MetricProcessorFactory.class,
    ServiceAuthContext.class
})
public class CoremonStateContext {

    @Bean
    CoremonShardFactory coremonShardFactory(
        ThreadPoolProvider threadPoolProvider,
        TCoremonEngineConfig engineConfig,
        Optional<TMetabaseMetricNameMigrationConfig> metricNameMigrationConfig,
        MetricsDaoFactory metricsDaoFactory,
        StockpileClient stockpileClient,
        MetricProcessorFactory processorFactory,
        ProcessingWriter stockpileBufferedWriter)
    {
        final ExecutorService parsingThreadPool;
        {
            String poolName = engineConfig.getParsingThreadPool();
            String configName = "CoremonEngineConfig.ParsingThreadPool";
            parsingThreadPool = threadPoolProvider.getExecutorService(poolName, configName);
        }

        final ExecutorService miscThreadPool;
        {
            String poolName = engineConfig.getMiscThreadPool();
            String configName = "CoremonEngineConfig.MiscThreadPool";
            miscThreadPool = threadPoolProvider.getExecutorService(poolName, configName);
        }

        return new CoremonShardFactory(
            parsingThreadPool,
            miscThreadPool,
            metricsDaoFactory,
            stockpileClient,
            processorFactory,
            metricNameMigrationConfig.orElse(TMetabaseMetricNameMigrationConfig.getDefaultInstance()),
            stockpileBufferedWriter);
    }

    @Bean
    StockpileBufferedWriter stockpileBufferedWriter(
        ThreadPoolProvider threadPoolProvider,
        TCoremonEngineConfig engineConfig,
        StockpileClient stockpileClient,
        MetricRegistry metricRegistry)
    {
        ExecutorService executor = threadPoolProvider.getExecutorService(
            engineConfig.getMiscThreadPool(),
            "CoremonEngineConfig.MiscThreadPool");
        return new StockpileBufferedWriter(stockpileClient, executor, metricRegistry);
    }

    @Bean
    ServiceProviderMetricsSupplier serviceProviderMetrics(CoremonState state) {
        return new ServiceProviderMetricsSupplier(state);
    }
}
