package ru.yandex.solomon.coremon;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author Vladimir Gordiychuk
 */
public class CoremonStateReloadLimiter {
    private static final int MAX_INFLIGHT = 5;
    private final AtomicInteger inflight = new AtomicInteger();
    private final Runnable onReload;

    public CoremonStateReloadLimiter(Runnable onReload) {
        this.onReload = onReload;
    }

    public boolean isAllow() {
        return inflight.get() < MAX_INFLIGHT;
    }

    public void add(CompletableFuture<?> future) {
        inflight.incrementAndGet();
        future.whenComplete((ignore, e) -> {
            inflight.decrementAndGet();
            onReload.run();
        });
    }
}
