package ru.yandex.solomon.coremon;

import java.time.Clock;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.core.conf.flags.FeatureFlagsContext;
import ru.yandex.solomon.coremon.balancer.MetabaseBalancerContext;
import ru.yandex.solomon.coremon.balancer.ShardLocatorImpl;
import ru.yandex.solomon.coremon.db.YdbClientsContext;
import ru.yandex.solomon.coremon.meta.service.MetabaseGrpcServerContext;
import ru.yandex.solomon.coremon.www.CoremonLocalShardsWww;
import ru.yandex.solomon.ctx.ServiceAuthContext;
import ru.yandex.solomon.http.filters.RequestLoggingFilter;
import ru.yandex.solomon.metrics.client.AbstractStockpileClientStub;
import ru.yandex.solomon.selfmon.GeneralMonitoringContext;
import ru.yandex.solomon.selfmon.mon.SelfMetricsController;
import ru.yandex.solomon.staffOnly.StaffOnlyController;
import ru.yandex.solomon.staffOnly.StaffOnlyRedirectController;
import ru.yandex.solomon.staffOnly.manager.ManagerController;
import ru.yandex.solomon.tracing.TracingContext;
import ru.yandex.stockpile.client.StockpileClient;


@Import({
    CoremonStateContext.class,
    RequestLoggingFilter.class,
    StaffOnlyController.class,
    StaffOnlyRedirectController.class,
    SelfMetricsController.class,
    ManagerController.class,
    MetabaseGrpcServerContext.class,
    GeneralMonitoringContext.class,
    LazyThreadPoolProvider.class,
    YdbClientsContext.class,
    MetabaseBalancerContext.class,
    ServiceAuthContext.class,
    FeatureFlagsContext.class,
    CoremonCloudContext.class,
    TracingContext.class,
    CoremonLocalShardsWww.class,
})
@Configuration
public class MetabaseMainContext {

    @Bean
    public Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    public StockpileClient dummyStockpileClient() {
        return new DummyStockpileClient();
    }

    public static class DummyStockpileClient extends AbstractStockpileClientStub {
        DummyStockpileClient() {
        }

        @Override
        public int getTotalShardsCount() {
            return 0;
        }
    }

    @Bean
    ShardLocatorImpl shardLocator() {
        return new ShardLocatorImpl();
    }
}
