package ru.yandex.solomon.coremon;

import javax.annotation.Nullable;

import ru.yandex.solomon.metrics.parser.ErrorListenerCounter;
import ru.yandex.solomon.proto.UrlStatusType;

/**
 * @author Sergey Polovko
 */
public class ProcessingResult {

    private final UrlStatusType statusType;
    private final String errorMessage;
    private final int metricCount;
    @Nullable
    private final ErrorListenerCounter parseErrors;

    private ProcessingResult(
        UrlStatusType statusType,
        String errorMessage,
        int metricCount,
        ErrorListenerCounter parseErrors)
    {
        this.statusType = statusType;
        this.errorMessage = errorMessage;
        this.metricCount = metricCount;
        this.parseErrors = parseErrors;
    }

    public static ProcessingResult maybeOk(
        UrlStatusType statusType, String errorMessage,
        int metricCount, ErrorListenerCounter parseErrors)
    {
        return new ProcessingResult(statusType, errorMessage, metricCount, parseErrors);
    }

    public static ProcessingResult ok(int metricCount, ErrorListenerCounter parseErrors) {
        return new ProcessingResult(UrlStatusType.OK, "", metricCount, parseErrors);
    }

    public static ProcessingResult fail(UrlStatusType statusType, String errorMessage) {
        return new ProcessingResult(statusType, errorMessage, 0, null);
    }

    public UrlStatusType getStatusType() {
        return statusType;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public int getMetricCount() {
        return metricCount;
    }

    @Nullable
    public ErrorListenerCounter getParseErrors() {
        return parseErrors;
    }

    @Override
    public String toString() {
        return "ProcessingResult{" +
            "statusType=" + statusType +
            ", errorMessage='" + errorMessage + '\'' +
            ", metricCount=" + metricCount +
            ", parseErrors=" + parseErrors +
            '}';
    }
}
