package ru.yandex.solomon.coremon.api;

import javax.annotation.Nullable;
import javax.annotation.WillClose;

import io.grpc.Server;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.utils.GrpcServerFactory;
import ru.yandex.grpc.utils.InternalGrpcService;
import ru.yandex.solomon.config.protobuf.rpc.TRpcServerConfig;
import ru.yandex.solomon.core.grpc.GrpcContext;

/**
 * @author Sergey Polovko
 */
@Component
@Import({
    CoremonGrpcService.class,
    GrpcContext.class
})
public class CoremonGrpcContext implements DisposableBean {

    private final GrpcServerFactory grpcServerFactory;

    @WillClose
    @Nullable
    private Server internalServer;

    @Autowired
    public CoremonGrpcContext(GrpcServerFactory grpcServerFactory) {
        this.grpcServerFactory = grpcServerFactory;
    }

    @Bean
    public Server getInternalServer(TRpcServerConfig config, InternalGrpcService[] internalServices) {
        this.internalServer = grpcServerFactory.makeServer(
            "RpcServerConfig.InternalGrpcServerConfig",
            config.getInternalGrpcServerConfig(),
            internalServices);
        grpcServerFactory.startWithTimeout(config.getInternalGrpcServerConfig(), internalServer);
        return internalServer;
    }

    @Override
    public void destroy() {
        Server server = this.internalServer;
        this.internalServer = null;
        if (server != null) {
            server.shutdown();
        }
    }
}
