package ru.yandex.solomon.coremon.api;

import java.util.concurrent.ConcurrentHashMap;

import com.google.common.net.HostAndPort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.grpc.conf.ClientOptionsFactory;
import ru.yandex.grpc.utils.GrpcClientOptions;
import ru.yandex.solomon.config.protobuf.coremon.TCoremonConfig;
import ru.yandex.solomon.config.protobuf.rpc.TGrpcClientConfig;
import ru.yandex.solomon.coremon.client.grpc.CoremonHostClient;

/**
 * @author Sergey Polovko
 */
@Component
class CoremonPeers implements AutoCloseable {

    // for lazy and dynamic expanding
    private final ConcurrentHashMap<String, CoremonHostClient> peers = new ConcurrentHashMap<>();
    private final int port;
    private final GrpcClientOptions options;
    private volatile boolean closed;

    @Autowired
    public CoremonPeers(
            TCoremonConfig config,
            ClientOptionsFactory clientOptionsFactory)
    {
        this.port = config.getRpcServerConfig().getInternalGrpcServerConfig().getPort(0);
        // XXX: use same configuration options as balancer uses, just to avoid configuration
        //      file overcomplication
        TGrpcClientConfig grpcConfig = config.getBalancerConfig().getGrpcConfig();
        this.options = clientOptionsFactory.newBuilder("CoremonClient", grpcConfig)
            .setClientId(config.getClientId())
            .build();
    }

    public CoremonHostClient get(String fqdn) {
        if (closed) {
            throw new IllegalStateException("CoremonPeers is closed");
        }

        HostAndPort address = HostAndPort.fromParts(fqdn, port);
        return peers.computeIfAbsent(fqdn, ignore -> new CoremonHostClient(address, options));
    }

    @Override
    public void close() {
        closed = true;
        for (CoremonHostClient client : peers.values()) {
            client.close();
        }
    }
}
