package ru.yandex.solomon.coremon.balancer;

import java.time.Clock;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.Nullable;

import ru.yandex.solomon.balancer.BalancerHolderImpl;
import ru.yandex.solomon.balancer.Resource;
import ru.yandex.solomon.balancer.ShardsHolder;
import ru.yandex.solomon.balancer.TotalShardCounter;
import ru.yandex.solomon.balancer.dao.BalancerDao;
import ru.yandex.solomon.balancer.remote.RemoteCluster;
import ru.yandex.solomon.locks.DistributedLock;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
//TODO: remove after migration to new balancer <SOLOMON-6713>
public class CoremonBalancerHolder extends BalancerHolderImpl {
    CoremonBalancerHolder(
        Clock clock,
        DistributedLock lock,
        List<Resource> resources,
        RemoteCluster cluster,
        ExecutorService executor,
        ScheduledExecutorService timer,
        ShardsHolder shardsHolder,
        TotalShardCounter shardCounter,
        BalancerDao dao)
    {
        super(clock, lock, resources, cluster, executor, timer, shardsHolder, shardCounter, dao);
    }

    @Nullable
    @Override
    public String getLeaderNode() {
        var leaderNode = super.getLeaderNode();
        if (leaderNode == null) {
            return null;
        }

        if (leaderNode.endsWith("_new")) {
            return leaderNode.substring(0, leaderNode.length() - 4);
        }

        return null;
    }
}
