package ru.yandex.solomon.coremon.balancer;

import ru.yandex.monlib.metrics.primitives.GaugeDouble;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Sergey Polovko
 */
class ShardBalancerMetrics {
    final GaugeInt64 isLeader;
    final GaugeInt64 hostsOffline;
    final GaugeInt64 hostsOnline;
    final Rate iterationOk;
    final Rate iterationFail;
    final GaugeDouble dispersion;
    final GaugeInt64 shards;
    final Rate rebalanceShards;
    final Rate deleteShards;
    final Rate addShards;

    ShardBalancerMetrics(MetricRegistry metricRegistry) {
        this.isLeader = metricRegistry.gaugeInt64("balancer.isLeader");
        this.hostsOffline = metricRegistry.gaugeInt64("balancer.hostsOffline");
        this.hostsOnline = metricRegistry.gaugeInt64("balancer.hostsOnline");
        this.iterationOk = metricRegistry.rate("balancer.iterationOk");
        this.iterationFail = metricRegistry.rate("balancer.iterationFail");
        this.dispersion = metricRegistry.gaugeDouble("balancer.dispersion");
        this.shards = metricRegistry.gaugeInt64("balancer.shard_count");
        this.rebalanceShards = metricRegistry.rate("balancer.rebalance_shards");
        this.deleteShards = metricRegistry.rate("balancer.delete_shards");
        this.addShards = metricRegistry.rate("balancer.add_shards");
    }

    void reset() {
        isLeader.set(0);
        hostsOffline.set(0);
        hostsOnline.set(0);
        dispersion.set(0);
        shards.set(0);
    }
}
