package ru.yandex.solomon.coremon.balancer;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;

import ru.yandex.solomon.core.db.model.ShardPartitionId;
import ru.yandex.solomon.coremon.balancer.state.ShardIds;
import ru.yandex.solomon.coremon.meta.service.ShardLocator;

/**
 * @author Sergey Polovko
 */
public class ShardLocatorImpl implements ShardLocator {

    @Nullable
    private volatile ShardIds ids;

    @Override
    public boolean isLocal(int shardId) {
        ShardIds ids = this.ids;
        return (ids != null) && ids.containsShard(shardId);
    }

    @Override
    public boolean isLocalPartition(ShardPartitionId key) {
        var ids = this.ids;
        return ids != null && ids.containsPartition(key);
    }

    public IntSet getLocalShards() {
        var ids = this.ids;
        if (ids == null) {
            return IntSets.EMPTY_SET;
        }
        return ids.getShards();
    }

    @Override
    public boolean isInitialized() {
        return ids != null;
    }

    public void setLocalShardIds(@Nonnull ShardIds ids) {
        Preconditions.checkNotNull(ids, "ids cannot be null");
        this.ids = ids;
    }

    @Override
    public int getLocalShardCount() {
        ShardIds ids = this.ids;
        if (ids == null) {
            return 0;
        }
        return ids.size();
    }
}
