package ru.yandex.solomon.coremon.balancer.db;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.SchemaAwareDao;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public interface BalancerShardsDao extends SchemaAwareDao {
    CompletableFuture<Void> upsert(BalancerShard shard);

    CompletableFuture<Void> delete(String shardId);

    CompletableFuture<List<BalancerShard>> findAll();

    CompletableFuture<Void> bulkUpsert(List<BalancerShard> shards);
}
