package ru.yandex.solomon.coremon.balancer.db;

import java.util.concurrent.CompletableFuture;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

import ru.yandex.solomon.balancer.BalancerOptions;
import ru.yandex.solomon.balancer.dao.BalancerDao;
import ru.yandex.solomon.balancer.snapshot.SnapshotAssignments;

import static java.util.concurrent.CompletableFuture.completedFuture;

/**
 * @author Stanislav Kashirin
 */
//TODO: remove after migration to new balancer <SOLOMON-6713>
public class CoremonMigrateBalancerDao implements BalancerDao {
    private final ShardAssignmentsDao assignmentsDao;
    private final BalancerDao balancerDao;

    public CoremonMigrateBalancerDao(ShardAssignmentsDao assignmentsDao, BalancerDao balancerDao) {
        this.assignmentsDao = assignmentsDao;
        this.balancerDao = balancerDao;
    }

    @Override
    public CompletableFuture<Void> createSchema() {
        return balancerDao.createSchema();
    }

    @Override
    public CompletableFuture<BalancerOptions> getOptions() {
        return balancerDao.getOptions();
    }

    @Override
    public CompletableFuture<Void> saveOptions(BalancerOptions opts) {
        return balancerDao.saveOptions(opts);
    }

    @Override
    public CompletableFuture<SnapshotAssignments> getAssignments() {
        // to simplify state sync between old & new balancers during migration stage
        // we never read persisted assignments, because it could be stale after balancer switching
        // new balancer should init its state from cluster pings only

        return completedFuture(SnapshotAssignments.EMPTY);
    }

    @Override
    public CompletableFuture<Void> saveAssignments(SnapshotAssignments assignments) {
        var shard2host = new Int2ObjectOpenHashMap<String>(assignments.shards.size());
        for (var shard : assignments.shards) {
            if (shard.node != null) {
                shard2host.put(Integer.parseUnsignedInt(shard.shardId), shard.node);
            }
        }

        return assignmentsDao.save(ShardAssignments.ownOf(shard2host))
            .thenCombine(balancerDao.saveAssignments(assignments), (i, j) -> null);
    }
}
