package ru.yandex.solomon.coremon.balancer.db;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

import static java.util.concurrent.CompletableFuture.delayedExecutor;
import static java.util.concurrent.CompletableFuture.runAsync;
import static java.util.concurrent.CompletableFuture.supplyAsync;

/**
 * @author Sergey Polovko
 */
public class MemShardBalancerOptionsDao implements ShardBalancerOptionsDao {

    private volatile ShardBalancerOptions options = ShardBalancerOptions.DEFAULT;

    @Override
    public CompletableFuture<ShardBalancerOptions> load() {
        return supplyAsync(() -> options, delayedExecutor(10, TimeUnit.MILLISECONDS));
    }

    @Override
    public CompletableFuture<Void> save(ShardBalancerOptions options) {
        return runAsync(() -> this.options = options, delayedExecutor(10, TimeUnit.MILLISECONDS));
    }
}
