package ru.yandex.solomon.coremon.balancer.db.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import org.intellij.lang.annotations.Language;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
class YdbBalancerShardsQuery {

    @Language("SQL")
    private static final String UPSERT = """
            --!syntax_v1
            DECLARE $id AS Utf8;
            DECLARE $createdAt AS Timestamp;

            UPSERT INTO `TABLE_PATH` (id, createdAt)
            VALUES ($id, $createdAt);
            """;

    @Language("SQL")
    private static final String DELETE = """
            --!syntax_v1
            DECLARE $id AS Utf8;

            DELETE FROM `TABLE_PATH`
            WHERE id = $id
            """;

    private final String tablePath;

    final String upsert;
    final String delete;

    YdbBalancerShardsQuery(String tablePath) {
        this.tablePath = tablePath;

        this.upsert = prepare(UPSERT);
        this.delete = prepare(DELETE);
    }

    private String prepare(String query) {
        return query
            .replaceAll("TABLE_PATH", tablePath);
    }
}
