package ru.yandex.solomon.coremon.balancer.state;

import javax.annotation.concurrent.Immutable;

import ru.yandex.monitoring.coremon.EShardState;

/**
 * @author Sergey Polovko
 */
@Immutable
public final class ShardLoad {

    private final int id;
    private final EShardState state;
    private final long uptimeMillis;
    private final long cpuTimeNanos;
    private final long metricsCount;
    private final long networkBytes;
    private final long parsedMetrics;

    public ShardLoad(
        int id,
        EShardState state,
        long uptimeMillis,
        long cpuTimeNanos,
        long metricsCount,
        long networkBytes,
        long parsedMetrics)
    {
        this.id = id;
        this.state = state;
        this.uptimeMillis = uptimeMillis;
        this.cpuTimeNanos = cpuTimeNanos;
        this.metricsCount = metricsCount;
        this.networkBytes = networkBytes;
        this.parsedMetrics = parsedMetrics;
    }

    public static ShardLoad inactive(int numId) {
        return new ShardLoad(numId, EShardState.INACTIVE, 0, 0, 0, 0, 0);
    }

    public int getId() {
        return id;
    }

    public EShardState getState() {
        return state;
    }

    public long getUptimeMillis() {
        return uptimeMillis;
    }

    public long getCpuTimeNanos() {
        return cpuTimeNanos;
    }

    public long getMetricsCount() {
        return metricsCount;
    }

    public long getNetworkBytes() {
        return networkBytes;
    }

    public long getParsedMetrics() {
        return parsedMetrics;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ShardLoad s = (ShardLoad) o;
        if (id != s.id) return false;
        if (uptimeMillis != s.uptimeMillis) return false;
        if (cpuTimeNanos != s.cpuTimeNanos) return false;
        if (metricsCount != s.metricsCount) return false;
        if (networkBytes != s.networkBytes) return false;
        if (parsedMetrics != s.parsedMetrics) return false;
        return state == s.state;
    }

    @Override
    public int hashCode() {
        int result = id;;
        result = 31 * result + state.hashCode();
        result = 31 * result + (int) (uptimeMillis ^ (uptimeMillis >>> 32));
        result = 31 * result + (int) (cpuTimeNanos ^ (cpuTimeNanos >>> 32));
        result = 31 * result + (int) (metricsCount ^ (metricsCount >>> 32));
        result = 31 * result + (int) (networkBytes ^ (networkBytes >>> 32));
        result = 31 * result + (int) (parsedMetrics ^ (parsedMetrics >>> 32));
        return result;
    }

    void toString(StringBuilder sb) {
        sb.append("{id=").append(Integer.toUnsignedLong(id));
        sb.append(", state=").append(state);
        sb.append(", uptimeMillis=").append(uptimeMillis);
        sb.append(", cpuTimeNanos=").append(cpuTimeNanos);
        sb.append(", memoryBytes=").append(metricsCount);
        sb.append(", networkBytes=").append(networkBytes);
        sb.append(", parsedMetrics=").append(parsedMetrics);
        sb.append('}');
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ShardInfo");
        toString(sb);
        return sb.toString();
    }
}
