package ru.yandex.solomon.coremon.db;

import java.util.Optional;

import com.yandex.ydb.table.SchemeClient;
import com.yandex.ydb.table.TableClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.cloud.token.IamTokenClient;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.TKikimrClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.secrets.SecretProvider;
import ru.yandex.solomon.ydb.YdbClients;

/**
 * @author Sergey Polovko
 */
@Configuration
public class YdbClientsContext implements DisposableBean {

    private final YdbClients ydbClients;

    public YdbClientsContext(
            @Qualifier("KikimrClientConfig") TKikimrClientConfig config,
            ThreadPoolProvider threadPoolProvider,
            MetricRegistry registry,
            Optional<IamTokenClient> iamTokenClient,
            SecretProvider secrets)
    {
        this.ydbClients = new YdbClients("KikimrClientConfig", config, threadPoolProvider, registry, iamTokenClient, secrets);
    }

    @Bean(name = "localTableClient")
    TableClient tableClient() {
        return ydbClients.getTableClient();
    }

    @Bean(name = "localSchemeClient")
    SchemeClient schemeClient() {
        return ydbClients.getSchemeClient();
    }

    @Bean(name = "localClientMetrics")
    MetricSupplier tableClientMetrics() {
        return ydbClients.getTableClientMetrics();
    }

    @Override
    public void destroy() {
        ydbClients.close();
    }
}
