package ru.yandex.solomon.coremon.shards;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.model.Shard;
import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Sergey Polovko
 */
interface Event {
    ShardKey getShardKey();

    /**
     * Sent when there is no shard in local configuration and we have to find shard in database
     * before start creating shard.
     */
    @ParametersAreNonnullByDefault
    class FindShard implements Event {
        final ShardKey shardKey;
        final String accountId;
        final CompletableFuture<Shard> future;

        FindShard(ShardKey shardKey, String accountId) {
            this.shardKey = shardKey;
            this.accountId = accountId;
            this.future = new CompletableFuture<>();
        }

        @Override
        public ShardKey getShardKey() {
            return shardKey;
        }
    }

    /**
     * Sent after we received an empty response to find request.
     */
    @ParametersAreNonnullByDefault
    class CreateShard implements Event {
        final ShardKey shardKey;
        final String accountId;

        CreateShard(FindShard findEvent) {
            this.shardKey = findEvent.shardKey;
            this.accountId = findEvent.accountId;
        }

        @Override
        public ShardKey getShardKey() {
            return shardKey;
        }
    }

    /**
     * Sent when shard was found or created.
     */
    @ParametersAreNonnullByDefault
    class ShardTaken implements Event {
        final ShardKey shardKey;
        final Shard shard;

        ShardTaken(ShardKey shardKey, Shard shard) {
            this.shardKey = shardKey;
            this.shard = shard;
        }

        @Override
        public ShardKey getShardKey() {
            return shardKey;
        }
    }

    /**
     * Sent when unexpected failure happened.
     */
    @ParametersAreNonnullByDefault
    class Failure implements Event {
        final ShardKey shardKey;
        final Throwable throwable;

        Failure(ShardKey shardKey, Throwable throwable) {
            this.shardKey = shardKey;
            this.throwable = throwable;
        }

        @Override
        public ShardKey getShardKey() {
            return shardKey;
        }
    }
}
