package ru.yandex.solomon.coremon.shards;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.conf.SolomonConfWithContext;
import ru.yandex.solomon.core.db.dao.ShardsDao;
import ru.yandex.solomon.core.db.model.Shard;
import ru.yandex.solomon.labels.shard.ShardKey;

/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
final class FindShardProcess extends ShardProcess {

    private final ShardKey shardKey;

    FindShardProcess(ShardCreationContext context, SolomonConfWithContext conf, ShardKey shardKey) {
        super(context, conf);
        this.shardKey = shardKey;

        doFind().whenComplete((shardO, throwable) -> {
            if (throwable != null) {
                getDoneFuture().completeExceptionally(throwable);
            } else {
                getDoneFuture().complete(shardO.orElse(null));
            }
        });
    }

    private CompletableFuture<Optional<Shard>> doFind() {
        ShardsDao shardDao = getContext().shardDao;
        return shardDao.findByShardKey(shardKey.getProject(), shardKey.getCluster(), shardKey.getService());
    }
}
