package ru.yandex.solomon.coremon.shards;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.cloud.resource.resolver.FolderResolver;
import ru.yandex.solomon.config.protobuf.coremon.TCoremonCreateShardConfig;
import ru.yandex.solomon.core.conf.ShardNumIdGenerator;
import ru.yandex.solomon.core.db.dao.ClustersDao;
import ru.yandex.solomon.core.db.dao.ProjectsDao;
import ru.yandex.solomon.core.db.dao.ServicesDao;
import ru.yandex.solomon.core.db.dao.ShardsDao;

/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
final class ShardCreationContext {

    final ProjectsDao projectsDao;
    final ShardsDao shardDao;
    final ClustersDao clusterDao;
    final ServicesDao serviceDao;
    final ShardNumIdGenerator shardNumIdGenerator;
    final TCoremonCreateShardConfig createShardConfig;
    final FolderResolver folderResolver;

    ShardCreationContext(
            ProjectsDao projectsDao,
            ShardsDao shardDao,
            ClustersDao clusterDao,
            ServicesDao serviceDao,
            ShardNumIdGenerator shardNumIdGenerator,
            TCoremonCreateShardConfig createShardConfig,
            FolderResolver folderResolver)
    {
        this.projectsDao = projectsDao;
        this.shardDao = shardDao;
        this.clusterDao = clusterDao;
        this.serviceDao = serviceDao;
        this.shardNumIdGenerator = shardNumIdGenerator;
        this.createShardConfig = createShardConfig;
        this.folderResolver = folderResolver;
    }
}
