package ru.yandex.solomon.coremon.shards;

import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.primitives.GaugeInt64;
import ru.yandex.monlib.metrics.primitives.Histogram;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * @author Sergey Polovko
 */
final class ShardCreatorMetrics {

    private final GaugeInt64 processesInFlight;
    private final Histogram processTimeMillis;
    private final Rate processOks;
    private final Rate processFails;
    private final Rate cacheHit;
    private final Rate cacheMiss;
    private final GaugeInt64 cacheSize;

    ShardCreatorMetrics(MetricRegistry registry) {
        processesInFlight = registry.gaugeInt64("shardCreator.processes.inFlight");
        processTimeMillis = registry.histogramRate("shardCreator.processes.timeMillis", Histograms.exponential(15, 2, 8));
        processOks = registry.rate("shardCreator.processes.oks");
        processFails = registry.rate("shardCreator.processes.fails");
        cacheHit = registry.rate("shardCreator.cache.hit");
        cacheMiss = registry.rate("shardCreator.cache.miss");
        cacheSize = registry.gaugeInt64("shardCreator.cache.size");
    }

    void startProcess() {
        processesInFlight.add(1);
    }

    void stopProcessOk(long elapsedMillis) {
        processesInFlight.add(-1);
        processTimeMillis.record(elapsedMillis);
        processOks.inc();
    }

    void stopProcessFail(long elapsedMillis) {
        processesInFlight.add(-1);
        processTimeMillis.record(elapsedMillis);
        processFails.inc();
    }

    void incCacheHit() {
        cacheHit.inc();
    }

    void incCacheMiss() {
        cacheMiss.inc();
    }

    void setCacheSize(long size) {
        cacheSize.set(size);
    }
}
