package ru.yandex.solomon.coremon.stockpile;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.conf.aggr.AggrRuleConf;

/**
 * @author checat
 */
@ParametersAreNonnullByDefault
public class CoremonMericConfDetailed {

    private final AggrRuleConf[] aggrRules;
    private final boolean rawDataMemOnly;
    private final boolean hostRequired;
    private final Set<String> aggrUseLabelNames;

    public CoremonMericConfDetailed(AggrRuleConf[] aggrRules, boolean rawDataMemOnly) {
        this.aggrRules = aggrRules;
        this.rawDataMemOnly = rawDataMemOnly;
        this.aggrUseLabelNames = Stream.of(aggrRules)
                .flatMap(aggrRuleConf -> Stream.concat(
                        aggrRuleConf.getConditionLabelNames().stream(),
                        aggrRuleConf.getSubstitutionLabelNames().stream()))
                .collect(Collectors.toUnmodifiableSet());
        this.hostRequired = !rawDataMemOnly || Stream.of(aggrRules).anyMatch(AggrRuleConf::isHostRequired);
    }

    public AggrRuleConf[] getAggrRules() {
        return aggrRules;
    }

    public Set<String> getAggrUseLabelNames() {
        return aggrUseLabelNames;
    }

    public boolean isRawDataMemOnly() {
        return rawDataMemOnly;
    }

    public boolean isHostRequired() {
        return hostRequired;
    }
}
