package ru.yandex.solomon.coremon.stockpile;

import ru.yandex.solomon.metrics.parser.MetricConsumer;
import ru.yandex.solomon.proto.UrlStatusType;

/**
 * @author Vladimir Gordiychuk
 */
public interface MetricProcessor extends MetricConsumer, AutoCloseable {

    MetricStats getMetricStats();

    Status getStatus();

    @Override
    void close();

    class Status {
        public static final Status OK = new Status(UrlStatusType.OK, "");

        private final UrlStatusType urlStatusType;
        private final String message;

        public Status(UrlStatusType urlStatusType, String message) {
            this.urlStatusType = urlStatusType;
            this.message = message;
        }

        public UrlStatusType getUrlStatusType() {
            return urlStatusType;
        }

        public String getMessage() {
            return message;
        }
    }
}
