package ru.yandex.solomon.coremon.stockpile;

import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.core.conf.ShardKeyAndId;
import ru.yandex.solomon.core.db.model.ValidationMode;
import ru.yandex.solomon.coremon.CoremonShardQuota;
import ru.yandex.solomon.coremon.aggregates.AggrHelper;
import ru.yandex.solomon.coremon.meta.mem.MemOnlyMetricsCollection;
import ru.yandex.solomon.flags.FeatureFlag;
import ru.yandex.solomon.flags.FeatureFlagsHolder;
import ru.yandex.solomon.metrics.parser.TreeParser;
import ru.yandex.stockpile.api.EDecimPolicy;

/**
 * @author Vladimir Gordiychuk
 */
@Component
@ParametersAreNonnullByDefault
public class MetricProcessorFactory {
    private final FeatureFlagsHolder featureFlagsHolder;

    public MetricProcessorFactory(FeatureFlagsHolder featureFlagsHolder) {
        this.featureFlagsHolder = featureFlagsHolder;
    }

    // TODO: reduce arguments count
    public MetricProcessor create(
        ShardKeyAndId key,
        AggrHelper aggrHelper,
        CoremonShardStockpileResolveHelper resolveHelper,
        CoremonShardStockpileWriteHelper writeHelper,
        MemOnlyMetricsCollection memOnlyMetrics,
        Labels optLabelSorted,
        boolean isPush,
        long responseTsMillis,
        long prevResponseTsMillis,
        Supplier<MetricsPrevValues> prevValues,
        long configuredGridMillis,
        long configuredFetchMillis,
        EDecimPolicy decimPolicyId,
        CoremonShardQuota quota,
        boolean isShardMemOnly,
        TreeParser.ErrorListener errors,
        ValidationMode validationMode)
    {
        return new MetricProcessorImpl(
            aggrHelper, resolveHelper, writeHelper,
            memOnlyMetrics, optLabelSorted,
            isPush,
            responseTsMillis,
            prevResponseTsMillis,
            prevValues,
            configuredGridMillis,
            configuredFetchMillis,
            decimPolicyId,
            quota,
            isShardMemOnly,
            errors,
            validationMode,
            isGridRounding(key));
    }

    public boolean isGridRounding(ShardKeyAndId key) {
        return featureFlagsHolder.hasFlag(FeatureFlag.GRID_ROUNDING, key.getNumId());
    }
}
