package ru.yandex.solomon.coremon.stockpile;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.solomon.util.collection.enums.EnumMapToInt;

/**
 * @author Sergey Polovko
 */
public class MetricStats {

    private int knownCount;
    private int unknownCount;
    private int timeseriesCount;
    private int timeseriesMoreOnePointCount;
    private final EnumMapToInt<MetricType> types;

    public MetricStats() {
        this.types = new EnumMapToInt<>(MetricType.class);
    }

    public int incCount(MetricType type) {
        knownCount++;
        types.addAndGet(type, 1);
        return knownCount;
    }

    public void incUnknown() {
        unknownCount++;
    }

    public void incTimeseries() {
        timeseriesCount++;
    }

    public void incTimeseriesMoreThenOnePoint() {
        timeseriesMoreOnePointCount++;
    }

    public int getCount() {
        return knownCount;
    }

    public int getUnknown() {
        return unknownCount;
    }

    public int getTimeseriesCount() {
        return timeseriesCount;
    }

    public int getTimeseriesMoreOnePointCount() {
        return timeseriesMoreOnePointCount;
    }

    public EnumMapToInt<MetricType> getTypes() {
        return types;
    }
}
