package ru.yandex.solomon.coremon.stockpile;

import javax.annotation.Nullable;

import ru.yandex.monlib.metrics.histogram.HistogramSnapshot;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
public interface MetricsPrevValues {
    MetricsPrevValues EMPTY = new Empty();

    static MetricsPrevValues empty() {
        return EMPTY;
    }

    double getDouble(Labels labels);

    @Nullable
    HistogramSnapshot getHistogram(Labels labels);

    class Empty implements MetricsPrevValues {
        private Empty() {
        }

        @Override
        public double getDouble(Labels labels) {
            return Double.NaN;
        }

        @Nullable
        @Override
        public HistogramSnapshot getHistogram(Labels labels) {
            return null;
        }
    }
}
