package ru.yandex.solomon.coremon.stockpile;

import javax.annotation.Nullable;

import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;

import ru.yandex.monlib.metrics.histogram.ExplicitHistogramSnapshot;
import ru.yandex.monlib.metrics.histogram.HistogramSnapshot;
import ru.yandex.monlib.metrics.labels.Labels;

/**
 * @author Vladimir Gordiychuk
 */
// can be recycable in a future
public class MetricsPrevValuesImpl implements MetricsPrevValues {
    final Object2DoubleOpenHashMap<Labels> doubles;
    final Object2ObjectOpenHashMap<Labels, HistogramSnapshot> histograms;

    MetricsPrevValuesImpl() {
        doubles = new Object2DoubleOpenHashMap<>();
        doubles.defaultReturnValue(Double.NaN);
        histograms = new Object2ObjectOpenHashMap<>();
        histograms.defaultReturnValue(ExplicitHistogramSnapshot.EMPTY);
    }

    @Override
    public double getDouble(Labels labels) {
        return doubles.getDouble(labels);
    }

    @Override
    @Nullable
    public HistogramSnapshot getHistogram(Labels labels) {
        return histograms.get(labels);
    }
}
