package ru.yandex.solomon.coremon.stockpile;

import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import io.netty.buffer.ByteBuf;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.series.TimeSeries;
import ru.yandex.solomon.core.urlStatus.UrlStatusTypeException;
import ru.yandex.solomon.metrics.parser.MetricConsumer;
import ru.yandex.solomon.metrics.parser.TreeParser;
import ru.yandex.solomon.proto.UrlStatusType;


/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
class MetricsPrevValuesProcessor implements MetricConsumer {
    private final MetricsPrevValuesImpl prevValues;
    private Labels labels;
    private MetricType type;

    MetricsPrevValuesProcessor() {
        prevValues = new MetricsPrevValuesImpl();
    }

    @Override
    public void ensureCapacity(int countHint) {
    }

    MetricsPrevValuesImpl getPrevValues() {
        return prevValues;
    }

    static Supplier<MetricsPrevValues> lazyParsed(
        Labels commonLabels,
        ByteBuf response,
        long responseTsMillis,
        TreeParser treeParser,
        boolean onlyNewFormatWrites)
    {
        if (response.readableBytes() == 0 || responseTsMillis == 0) {
            return MetricsPrevValues::empty;
        }

        return () -> {
                MetricsPrevValuesProcessor processor = new MetricsPrevValuesProcessor();
                treeParser.parseAndProcess(
                    commonLabels,
                    response,
                    processor,
                    TreeParser.ErrorListenerIgnore.I,
                    TreeParser.FormatListenerIgnore.I,
                    onlyNewFormatWrites);
                return processor.getPrevValues();
            };
    }

    @Override
    public void onMetricBegin(MetricType type, Labels labels, boolean memOnly) {
        this.type = type;
        this.labels = labels;
    }

    @Override
    public void onPoint(long tsMillis, double value) {
        if (type != MetricType.RATE && type != MetricType.HIST_RATE) {
            return;
        }

        prevValues.doubles.put(labels, value);

        if (tsMillis != 0) {
            // https://nda.ya.ru/3SSi4D
            throw new UrlStatusTypeException(UrlStatusType.DERIV_AND_TS);
        }
    }

    @Override
    public void onPoint(long tsMillis, long value) {
        onPoint(tsMillis, (double) value);
    }

    @Override
    public void onTimeSeries(TimeSeries timeSeries) {
        if (type != MetricType.RATE && type != MetricType.HIST_RATE) {
            return;
        }

        if (!timeSeries.isEmpty()) {
            throw new UrlStatusTypeException(UrlStatusType.DERIV_AND_TS);
        }
    }
}
