package ru.yandex.solomon.coremon.stockpile;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.solomon.coremon.CoremonShard;
import ru.yandex.solomon.staffOnly.html.HtmlWriterWithCommonLibraries;
import ru.yandex.solomon.staffOnly.manager.ManagerController;
import ru.yandex.solomon.staffOnly.manager.find.NamedObjectId;

/**
 * @author Vladimir Gordiychuk
 */
public class MetricsProcessorFactoryWww {

    public static void printExtra(HtmlWriterWithCommonLibraries hw, Map<String, Boolean> tasks) {
        List<Map.Entry<String, Boolean>> rows = tasks.entrySet().stream()
                .sorted(Comparator.comparing(Map.Entry::getKey))
                .collect(Collectors.toList());

        hw.h2("Per shard use write approach");
        hw.tableTable(() -> {
            hw.trThs("CreatedAt", "ShardId", "Status", "Duration", "Stats", "Details");

            for (Map.Entry<String, Boolean> row : rows) {
                final String shardId = row.getKey();
                final Boolean value = row.getValue();

                hw.tr(() -> {
                    // ShardId
                    hw.td(() -> {
                        String shardHref = ManagerController.namedObjectLink(new NamedObjectId(CoremonShard.class, shardId));
                        hw.aHref(shardHref, shardId);
                    });

                    // Status
                    hw.td(() -> {
                        if (value) {
                            hw.label("success", "NEW");
                        } else {
                            hw.label("info", "OLD");
                        }
                    });
                });
            }
        });
    }
}
