package ru.yandex.solomon.coremon.stockpile;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.validate.StrictValidator;
import ru.yandex.solomon.core.db.model.ValidationMode;
import ru.yandex.solomon.core.urlStatus.UrlStatusTypeException;
import ru.yandex.solomon.metrics.parser.TreeParser;
import ru.yandex.solomon.proto.UrlStatusType;

/**
 * @author Vladimir Gordiychuk
 */
public class Validator {

    static boolean isNotValid(ValidationMode mode, Labels labels, TreeParser.ErrorListener errors) {
        if (mode == ValidationMode.LEGACY_SKIP) {
            return false;
        }
        // use strict validation rules for new metrics
        boolean validMetrics = StrictValidator.SELF.isValid(labels);
        if (mode == ValidationMode.STRICT_SKIP) {
            if (!validMetrics) {
                errors.invalidMetric(TreeParser.InvalidMetricReason.INVALID_LABEL);
                return true;
            }
        } else if (mode == ValidationMode.STRICT_FAIL) {
            if (!validMetrics) {
                errors.invalidMetric(TreeParser.InvalidMetricReason.INVALID_LABEL);
                throw new UrlStatusTypeException(UrlStatusType.PARSE_ERROR);
            }
        }
        return false;
    }
}
