package ru.yandex.solomon.coremon.stockpile.write;

import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.StepColumn;


/**
 * @author Sergey Polovko
 */
public final class Points {
    private Points() {}

    /**
     * Fill simple point with given data.
     */
    public static void fillSimple(
        AggrPoint point,
        long tsMillis, long stepMillis,
        double valueNum, long valueDenom)
    {
        point.reset();
        point.setTsMillis(tsMillis);
        point.setValue(valueNum, valueDenom);
        if (stepMillis != StepColumn.DEFAULT_VALUE) {
            point.setStepMillis(stepMillis);
        }
    }

    /**
     * Fill aggregate point with given data and timestamp that must be aligned by {@code stepMillis} grid.
     */
    public static void fillAggregate(
        AggrPoint point,
        long tsMillis, long stepMillis,
        double valueNum, long valueDenom)
    {
        if (!Double.isNaN(valueNum)) {
            point.reset();
            point.setValue(valueNum, valueDenom);
            point.setMerge(true);
            point.setCount(1);
            if (stepMillis != StepColumn.DEFAULT_VALUE) {
                // stepMillis grid alignment
                tsMillis -= (tsMillis % stepMillis);
                point.setTsMillis(tsMillis);
                point.setStepMillis(stepMillis);
            } else {
                point.setTsMillis(tsMillis);
            }
        }
    }

}
