package ru.yandex.solomon.coremon.stockpile.write;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.memory.layout.MemMeasurable;
import ru.yandex.solomon.memory.layout.MemoryCounter;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.protobuf.MetricTypeConverter;


/**
 * @author Sergey Polovko
 */
public class UnresolvedMetricPoint implements UnresolvedMetricData, MemMeasurable {
    private static final long SELF_SIZE = MemoryCounter.objectSelfSizeLayout(UnresolvedMetricPoint.class);

    private final Labels labels;
    private final MetricType type;
    // TODO: drop after completely move deriv calculation into stockpile (gordiychuk@)
    private final ru.yandex.solomon.model.protobuf.MetricType writeType;
    private final AggrPoint point;

    public UnresolvedMetricPoint(Labels labels, MetricType type, AggrPoint point) {
        this(labels, type, MetricTypeConverter.toNotNullProto(type), point);
    }

    public UnresolvedMetricPoint(Labels labels, MetricType type, ru.yandex.solomon.model.protobuf.MetricType writeType, AggrPoint point) {
        this.labels = labels;
        this.type = type;
        this.writeType = writeType;
        this.point = new AggrPoint(point);
    }

    @Override
    public Labels getLabels() {
        return labels;
    }

    @Override
    public MetricType getType() {
        return type;
    }

    @Override
    public ru.yandex.solomon.model.protobuf.MetricType getWriteType() {
        return writeType;
    }

    @Override
    public int pointsCount() {
        return 1;
    }

    @Override
    public void get(int index, AggrPoint point) {
        if (index != 0) {
            throw new IllegalArgumentException(String.format(
                "pointIndex out of bounds, got: %d, valid range: [0, %d)", index, pointsCount()));
        }
        this.point.copyTo(point);
    }

    public AggrPoint point() {
        return point;
    }

    @Override
    public String toString() {
        return "UnresolvedMetricPoint{" +
            "labels=" + labels +
            ", type=" + type +
            ", writeType=" + writeType +
            ", point=" + point +
            '}';
    }

    @Override
    public long memorySizeIncludingSelf() {
        return SELF_SIZE;
    }
}
