package ru.yandex.solomon.coremon.stockpile.write;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.protobuf.MetricTypeConverter;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;


/**
 * @author Sergey Polovko
 */
public class UnresolvedMetricTimeSeries implements UnresolvedMetricData {

    private final Labels labels;
    private final MetricType type;
    private final ru.yandex.solomon.model.protobuf.MetricType writeType;
    private final AggrGraphDataArrayList timeseries;
    private final int columnSet;

    public UnresolvedMetricTimeSeries(Labels labels, MetricType type, AggrGraphDataArrayList timeseries) {
        this(labels, type, MetricTypeConverter.toNotNullProto(type), timeseries);
    }

    public UnresolvedMetricTimeSeries(
            Labels labels, MetricType type, ru.yandex.solomon.model.protobuf.MetricType writeType,
            AggrGraphDataArrayList timeseries)
    {
        this.labels = labels;
        this.type = type;
        this.writeType = writeType;
        this.timeseries = timeseries;
        this.columnSet = timeseries.columnSetMask();
    }

    @Override
    public Labels getLabels() {
        return labels;
    }

    @Override
    public MetricType getType() {
        return type;
    }

    @Override
    public ru.yandex.solomon.model.protobuf.MetricType getWriteType() {
        return writeType;
    }

    @Override
    public int pointsCount() {
        return timeseries.length();
    }

    @Override
    public void get(int index, AggrPoint point) {
        timeseries.getDataTo(index, point);
        point.columnSet = columnSet;
    }

    @Override
    public String toString() {
        return "UnresolvedMetricData{" +
            "labels=" + labels +
            ", type=" + type +
            ", writeType=" + writeType +
            ", points=" + timeseries.toString() +
            "}";
    }
}
